/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.quickteleports;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.itsmeow.quickteleports.forge.QuickTeleportsModImpl;
import dev.itsmeow.quickteleports.util.HereTeleport;
import dev.itsmeow.quickteleports.util.Teleport;
import dev.itsmeow.quickteleports.util.ToTeleport;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class QuickTeleportsMod {
    public static final String MOD_ID = "quickteleports";
    public static final String CONFIG_FIELD_NAME = "teleport_request_timeout";
    public static final String CONFIG_FIELD_COMMENT = "Timeout until a teleport request expires, in seconds.";
    public static final int CONFIG_FIELD_VALUE = 30;
    public static final int CONFIG_FIELD_MIN = 0;
    public static final int CONFIG_FIELD_MAX = Integer.MAX_VALUE;
    public static HashMap<Teleport, Integer> tps = new HashMap();

    public static void registerCommands(CommandDispatcher dispatcher) {
        Predicate<CommandSourceStack> isPlayer = source -> {
            try {
                return source.m_81375_() != null;
            }
            catch (CommandSyntaxException e) {
                return false;
            }
        };
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tpa").requires(isPlayer)).then(Commands.m_82129_((String)"target", (ArgumentType)GameProfileArgument.m_94584_()).executes(command -> {
            ServerPlayer player = ((CommandSourceStack)command.getSource()).m_81375_();
            MinecraftServer server = player.m_20194_();
            Collection profiles = GameProfileArgument.m_94590_((CommandContext)command, (String)"target");
            if (profiles.size() > 1) {
                QuickTeleportsMod.sendMessage((CommandSourceStack)command.getSource(), false, Component.m_237113_((String)"Specify one player as an argument!").m_130940_(ChatFormatting.RED));
                return 0;
            }
            GameProfile profile = QuickTeleportsMod.getFirstProfile(profiles);
            if (!QuickTeleportsMod.isGameProfileOnline(server, profile)) {
                QuickTeleportsMod.sendMessage((CommandSourceStack)command.getSource(), false, Component.m_237113_((String)"This player is not online!").m_130940_(ChatFormatting.RED));
                return 0;
            }
            if (profile.getId().equals(player.m_36316_().getId())) {
                QuickTeleportsMod.sendMessage((CommandSourceStack)command.getSource(), false, Component.m_237113_((String)"You cannot teleport to yourself!").m_130940_(ChatFormatting.RED));
                return 0;
            }
            String sourceName = player.m_7755_().getString();
            ServerPlayer targetPlayer = server.m_6846_().m_11259_(profile.getId());
            Teleport remove = QuickTeleportsMod.getRequestTP(sourceName);
            if (remove != null) {
                tps.remove(remove);
                QuickTeleportsMod.notifyCanceledTP(server, remove);
            }
            ToTeleport teleport = new ToTeleport(sourceName, targetPlayer.m_7755_().getString());
            tps.put(teleport, QuickTeleportsMod.getTeleportTimeout() * 20);
            QuickTeleportsMod.sendMessage(targetPlayer.m_20203_(), true, Component.m_237113_((String)sourceName).m_130940_(ChatFormatting.GREEN), Component.m_237113_((String)" has requested to teleport to you. Type ").m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)"/tpaccept").m_130940_(ChatFormatting.YELLOW), Component.m_237113_((String)" to accept.").m_130940_(ChatFormatting.GOLD));
            QuickTeleportsMod.sendMessage((CommandSourceStack)command.getSource(), true, Component.m_237113_((String)"Requested to teleport to ").m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)targetPlayer.m_7755_().getString()).m_130940_(ChatFormatting.GREEN), Component.m_237113_((String)".").m_130940_(ChatFormatting.GOLD));
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tpaccept").requires(isPlayer)).executes(command -> {
            ServerPlayer player = ((CommandSourceStack)command.getSource()).m_81375_();
            MinecraftServer server = player.m_20194_();
            Teleport tp = QuickTeleportsMod.getSubjectTP(player.m_7755_().getString());
            if (tp == null) {
                QuickTeleportsMod.sendMessage((CommandSourceStack)command.getSource(), false, QuickTeleportsMod.ftc(ChatFormatting.RED, "You have no pending teleport requests!"));
                return 0;
            }
            tps.remove(tp);
            ServerPlayer playerRequesting = server.m_6846_().m_11255_(tp.getRequester());
            ServerPlayer playerMoving = server.m_6846_().m_11255_(tp.getSubject());
            if (playerMoving == null) {
                QuickTeleportsMod.sendMessage((CommandSourceStack)command.getSource(), false, QuickTeleportsMod.ftc(ChatFormatting.RED, "The player that is teleporting no longer exists!"));
                return 0;
            }
            if (tp instanceof ToTeleport) {
                ServerPlayer holder = playerMoving;
                playerMoving = playerRequesting;
                playerRequesting = holder;
            }
            QuickTeleportsMod.sendMessage(playerRequesting.m_20203_(), true, QuickTeleportsMod.ftc(ChatFormatting.GREEN, "Teleport request accepted."));
            QuickTeleportsMod.sendMessage(playerMoving.m_20203_(), true, QuickTeleportsMod.ftc(ChatFormatting.GREEN, tp instanceof ToTeleport ? "Your teleport request has been accepted." : "You are now being teleported."));
            double posX = playerRequesting.m_20185_();
            double posY = playerRequesting.m_20186_();
            double posZ = playerRequesting.m_20189_();
            playerMoving.m_8999_(playerRequesting.m_9236_(), posX, posY, posZ, playerRequesting.m_146908_(), 0.0f);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tpahere").requires(isPlayer)).then(Commands.m_82129_((String)"target", (ArgumentType)GameProfileArgument.m_94584_()).executes(command -> {
            ServerPlayer player = ((CommandSourceStack)command.getSource()).m_81375_();
            MinecraftServer server = player.m_20194_();
            Collection profiles = GameProfileArgument.m_94590_((CommandContext)command, (String)"target");
            if (profiles.size() > 1) {
                QuickTeleportsMod.sendMessage((CommandSourceStack)command.getSource(), false, QuickTeleportsMod.ftc(ChatFormatting.RED, "Specify one player as an argument!"));
                return 0;
            }
            GameProfile profile = QuickTeleportsMod.getFirstProfile(profiles);
            if (!QuickTeleportsMod.isGameProfileOnline(server, profile)) {
                QuickTeleportsMod.sendMessage((CommandSourceStack)command.getSource(), false, QuickTeleportsMod.ftc(ChatFormatting.RED, "This player is not online!"));
                return 0;
            }
            if (profile.getId().equals(player.m_36316_().getId())) {
                QuickTeleportsMod.sendMessage((CommandSourceStack)command.getSource(), false, QuickTeleportsMod.ftc(ChatFormatting.RED, "You cannot send a teleport request to yourself!"));
                return 0;
            }
            String sourceName = player.m_7755_().getString();
            Teleport remove = QuickTeleportsMod.getRequestTP(sourceName);
            if (remove != null) {
                tps.remove(remove);
                QuickTeleportsMod.notifyCanceledTP(server, remove);
            }
            ServerPlayer targetPlayer = server.m_6846_().m_11259_(profile.getId());
            HereTeleport tp = new HereTeleport(sourceName, targetPlayer.m_7755_().getString());
            tps.put(tp, QuickTeleportsMod.getTeleportTimeout() * 20);
            QuickTeleportsMod.sendMessage(targetPlayer.m_20203_(), true, QuickTeleportsMod.ftc(ChatFormatting.GREEN, sourceName), QuickTeleportsMod.ftc(ChatFormatting.GOLD, " has requested that you teleport to them. Type "), QuickTeleportsMod.ftc(ChatFormatting.YELLOW, "/tpaccept"), QuickTeleportsMod.ftc(ChatFormatting.GOLD, " to accept."));
            QuickTeleportsMod.sendMessage((CommandSourceStack)command.getSource(), true, QuickTeleportsMod.ftc(ChatFormatting.GOLD, "Requested "), QuickTeleportsMod.ftc(ChatFormatting.GREEN, targetPlayer.m_7755_().getString()), QuickTeleportsMod.ftc(ChatFormatting.GOLD, " to teleport to you."));
            return 1;
        })));
    }

    public static MutableComponent ftc(ChatFormatting format, String text) {
        return Component.m_237113_((String)text).m_130940_(format);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int getTeleportTimeout() {
        return QuickTeleportsModImpl.getTeleportTimeout();
    }

    private static boolean isGameProfileOnline(MinecraftServer server, GameProfile profile) {
        ServerPlayer player = server.m_6846_().m_11259_(profile.getId());
        return player != null && server.m_6846_().m_11314_().contains(player);
    }

    private static GameProfile getFirstProfile(Collection<GameProfile> profiles) {
        Iterator<GameProfile> iterator = profiles.iterator();
        if (iterator.hasNext()) {
            GameProfile profile = iterator.next();
            return profile;
        }
        return null;
    }

    @Nullable
    public static Teleport getSubjectTP(String name) {
        for (Teleport pair : tps.keySet()) {
            if (!pair.getSubject().equalsIgnoreCase(name)) continue;
            return pair;
        }
        return null;
    }

    @Nullable
    public static Teleport getRequestTP(String name) {
        for (Teleport pair : tps.keySet()) {
            if (!pair.getRequester().equalsIgnoreCase(name)) continue;
            return pair;
        }
        return null;
    }

    public static void serverTick(MinecraftServer server) {
        HashSet<Teleport> toRemove = new HashSet<Teleport>();
        for (Teleport tp : tps.keySet()) {
            int time = tps.get(tp);
            if (time > 0) {
                tps.put(tp, --time);
                continue;
            }
            if (time > 0) continue;
            toRemove.add(tp);
            QuickTeleportsMod.notifyTimeoutTP(server, tp);
        }
        for (Teleport remove : toRemove) {
            tps.remove(remove);
        }
    }

    public static void notifyTimeoutTP(MinecraftServer server, Teleport tp) {
        ServerPlayer tper = server.m_6846_().m_11255_(tp.getRequester());
        ServerPlayer target = server.m_6846_().m_11255_(tp.getSubject());
        if (target != null) {
            QuickTeleportsMod.sendMessage(target.m_20203_(), true, QuickTeleportsMod.ftc(ChatFormatting.GOLD, "Teleport request from "), QuickTeleportsMod.ftc(ChatFormatting.GREEN, tp.getRequester()), QuickTeleportsMod.ftc(ChatFormatting.GOLD, " timed out."));
        }
        if (tper != null) {
            QuickTeleportsMod.sendMessage(tper.m_20203_(), true, QuickTeleportsMod.ftc(ChatFormatting.GOLD, "Your request to "), QuickTeleportsMod.ftc(ChatFormatting.GREEN, tp.getSubject()), QuickTeleportsMod.ftc(ChatFormatting.GOLD, " has timed out after not being accepted."));
        }
    }

    public static void notifyCanceledTP(MinecraftServer server, Teleport tp) {
        ServerPlayer tper = server.m_6846_().m_11255_(tp.getRequester());
        ServerPlayer target = server.m_6846_().m_11255_(tp.getSubject());
        if (target != null) {
            QuickTeleportsMod.sendMessage(target.m_20203_(), true, QuickTeleportsMod.ftc(ChatFormatting.GOLD, "Teleport request from "), QuickTeleportsMod.ftc(ChatFormatting.GREEN, tp.getRequester()), QuickTeleportsMod.ftc(ChatFormatting.GOLD, " has been cancelled."));
        }
        if (tper != null) {
            QuickTeleportsMod.sendMessage(tper.m_20203_(), true, QuickTeleportsMod.ftc(ChatFormatting.GOLD, "Your request to "), QuickTeleportsMod.ftc(ChatFormatting.GREEN, tp.getSubject()), QuickTeleportsMod.ftc(ChatFormatting.GOLD, " has been cancelled."));
        }
    }

    public static void sendMessage(CommandSourceStack source, boolean success, MutableComponent ... styled) {
        if (styled.length > 0) {
            MutableComponent comp = styled[0];
            if (styled.length > 1) {
                for (int i = 1; i < styled.length; ++i) {
                    comp.m_7220_((Component)styled[i]);
                }
            }
            if (success) {
                source.m_81354_((Component)comp, false);
            } else {
                source.m_81352_((Component)comp);
            }
        }
    }
}

